//------------------------------------------------------------------------------
// File name:	C290PCIE_TOP
// Project:		C290PCIE board
// Author:		Sun Di
// Revision:	V2.2
// Data:		2013.04
//------------------------------------------------------------------------------

`timescale 1ns/100ps

`define	CHIPID1		5'h00
`define	CHIPID2		5'h01
`define	HWVER			5'h02
`define	SWVER			5'h03

`define	RSTCON		5'h10
`define	FLHCSR		5'h11
`define	WDCSR			5'h12
`define	WDKICK		5'h13
`define	FANCSR		5'h14
`define	LEDCSR		5'h15
`define	MISCCSR		5'h16
`define	BOOTOR		5'h17
`define	BOOTCFG1		5'h18
`define	BOOTCFG2		5'h19
`define	BOOTCFG3		5'h1a
`define	BOOTCFG4		5'h1b

module oamp (
	//input
	cpld_refclk,
	ifc_clk,
	
	cpld_cs_n,
	ifc_oe_n,
	
	nand_rb_n,
	boot_flash_sel,
	ifc_cs0_n,
	ifc_cs1_n,
	
	pon_rst_n,
	pex_rst_n,
	ps_rst_n,
	
	cop_trst_n,
	cop_srst_n,
	cop_hrst_n,
	
	wdo_n,
	
	sw_cfg_rom_loc,

	test_sel_n,	
	ext_pwr_det,
	therm_n,
	vcore_mgn,
	
	//output
	nor_cs_n,
	nand_cs_n,
	
	ifc_rb0_n,
	ifc_rb1_n,
	
	fbank_sel1,
	fbank_sel2,

	cpu_trst_n,
	hrst_n,
	nor_rst_n,
	ddr3_rst_n,
	ge1_rst_n,
	ge2_rst_n,
	
	wdi,
	wd_cfg,
		
	ready,
	sw_tsec1_txd0,
	sw_tsec1_txd1,
	uart1_rts_n,
	ifc_ad8,
	dma_dack0_n,
	ieee1588_clk_out,
	ieee1588_pulse_out,
	ifc_par1,
	ifc_a19,
	dma_ddone0_n,
	sw_tsec2_txd0,
	ckstp_out_n,
	ifc_avd,
	ifc_cle,
	uart0_txd,
	sw_ec_mdc,
	uart0_rts_n,
	
	fan_pwm,
	cpld_int_n,
	po1vdd_en,
	po2vdd_en,
	load_pwr_n,
	ps_1v0_mgn,
	led_grn,
	
	//inout
	ifc_a23_27,
	ifc_ad,
	ifc_we_n,
	
	hrst_req_n
);

// I/O declarations
input			cpld_refclk;
input			ifc_clk;
input			cpld_cs_n;
input			ifc_oe_n;
input			nand_rb_n;
input			boot_flash_sel;
input			ifc_cs0_n;
input			ifc_cs1_n;
input			pon_rst_n;
input			pex_rst_n;
input			ps_rst_n;
input			cop_trst_n;
input			cop_srst_n;
input			cop_hrst_n;
input			wdo_n;
input[3:0]	sw_cfg_rom_loc;
input			test_sel_n;
input			ext_pwr_det;
input			therm_n;
input			vcore_mgn;

output		nor_cs_n;
output		nand_cs_n;
output		ifc_rb0_n;
output		ifc_rb1_n;
output		fbank_sel1;
output		fbank_sel2;
output		cpu_trst_n;
output		hrst_n;
output		nor_rst_n;
output		ddr3_rst_n;
output		ge1_rst_n;
output		ge2_rst_n;
output		wdi;
output[2:0]	wd_cfg;
output		ready;
output		sw_tsec1_txd0;
output		sw_tsec1_txd1;
output		uart1_rts_n;
output		ifc_ad8;
output		dma_dack0_n;
output		ieee1588_clk_out;
output		ieee1588_pulse_out;
output		ifc_par1;
output		ifc_a19;
output		dma_ddone0_n;
output		sw_tsec2_txd0;
output		ckstp_out_n;
output		ifc_avd;
output		ifc_cle;
output		uart0_txd;
output		sw_ec_mdc;
output		uart0_rts_n;
output		fan_pwm;
output		cpld_int_n;
output		po1vdd_en;
output		po2vdd_en;
output		load_pwr_n;
output		ps_1v0_mgn;
output		led_grn;

inout[4:0]	ifc_a23_27;
inout[7:0]	ifc_ad;
inout			ifc_we_n;
inout			hrst_req_n;

// Internal signal declarations
wire			global_rst_n;
wire			bootcfg_rst_n;

reg			cpld_cs;
reg			cpld_oe;
reg			cpld_we;

reg			rst_hold_f;
reg[31:0]	rst_hold_cnt;

reg			global_rst_r;
reg[5:0]		global_rst_cnt;
reg			pex_rst_r;
reg[2:0]		pex_rst_old;
reg			hrst_req_r;
reg[1:0]		hrst_req_old;
reg			sw_rst_r;
reg			sw_rst_rr;
reg[1:0]		sw_rst_old;
reg[7:0]		sw_rst_cnt;
reg			ge1_rst_r;
reg			ge2_rst_r;
reg			fbank_override_r;
reg			fbank_sel1_r;
reg			fbank_sel2_r;
reg			wd_en_r;
reg[2:0]		wd_cfg_r;
reg			wd_kick_r;
reg			extpwr_det_r;
reg			therm_r;
reg[3:0]		fan_pwm_r;
reg[3:0]		pwm_cnt;
reg			fan_out;
reg[16:0]	led_clk_cnt;
reg			led_flash_out;
reg			led_r;
reg			po1vdd_en_r;
reg			po2vdd_en_r;
reg[2:0]		povdd_delay_cnt;
reg			povdd_out;
reg			sw_cfg_sb_dis_r;

reg			boot_override_r;
reg[2:0]		cfg_sys_pll_r;
reg			cfg_sys_speed_r;
reg[2:0]		cfg_core_pll_r;
reg			cfg_core_speed_r;
reg[2:0]		cfg_ddr_pll_r;
reg[1:0]		cfg_ddr_speed_r;
reg			cfg_plat_speed_r;
reg[1:0]		cfg_boot_seq_r;
reg			cfg_cpu_boot_r;
reg			cfg_sb_dis_r;
reg[1:0]		cfg_svr_r;
reg[3:0]		cfg_gpinput_r;
reg[1:0]		cfg_eng_use_r;
reg[3:0]		cfg_rom_loc_r;

reg[7:0] 	ifc_dout;

// Parameters
parameter	RST_HOLD_TIME = 32'd130000;

//--------------------------------------------------------------------------
// Module code

assign	global_rst_n = ps_rst_n & ~pex_rst_r;
//assign	global_rst_n = pon_rst_n & ps_rst_n & ~pex_rst_r;
//assign	bootcfg_rst_n = ps_rst_n & ~pex_rst_r & cop_hrst_n & (wd_en_r? wdo_n : 1'b1) & ~sw_rst_rr;
assign	bootcfg_rst_n = ps_rst_n & ~pex_rst_r & cop_hrst_n & (wd_en_r? wdo_n : 1'b1) & global_rst_r & ~sw_rst_rr;
//assign	bootcfg_rst_n = pon_rst_n & ps_rst_n & ~pex_rst_r & cop_hrst_n & (wd_en_r? wdo_n : 1'b1) & global_rst_r & ~sw_rst_rr;

always @(posedge ifc_clk)
begin
	if(!global_rst_n)
	begin
		cpld_cs <= 0;
		cpld_oe <= 0;
		cpld_we <= 0;
	end
	else
	begin
		cpld_cs <= ~cpld_cs_n;
		cpld_oe <= ~cpld_cs_n & ~ifc_oe_n;
		cpld_we <= ~cpld_cs_n & ~ifc_we_n;
	end
end
	
always @(posedge ifc_clk or negedge ps_rst_n)
begin
	if(!ps_rst_n)
	begin
		sw_rst_r <= 0;
		ge1_rst_r <= 0;
		ge2_rst_r <= 0;
		fbank_override_r <= 0;
		fbank_sel1_r <= 0;
		fbank_sel2_r <= 0;
		wd_en_r <= 0;
		wd_cfg_r <= 3'b111;
		wd_kick_r <= 0;
		fan_pwm_r <= 4'b1111;
		led_r <= 0;
		po1vdd_en_r <= 0;
		po2vdd_en_r <= 0;
		ifc_dout <= 8'h00;
		boot_override_r <= 0;
		cfg_sys_pll_r <= 3'b000;
		cfg_sys_speed_r <= 0;
		cfg_core_pll_r <= 3'b000;
		cfg_core_speed_r <= 0;
		cfg_ddr_pll_r <= 3'b000;
		cfg_ddr_speed_r <= 2'b00;
		cfg_plat_speed_r <= 0;
		cfg_boot_seq_r <= 2'b00;
		cfg_cpu_boot_r <= 0;
		cfg_sb_dis_r <= 0;
		cfg_svr_r <= 2'b00;
		cfg_gpinput_r <= 4'b0000;
		cfg_eng_use_r <= 2'b00;
		cfg_rom_loc_r <= 4'b0000;
	end
	else
	begin
		if(cpld_cs & cpld_we)
		begin
			case(ifc_a23_27)
				`RSTCON:	begin
								sw_rst_r <= ifc_ad[7];
								ge1_rst_r <= ifc_ad[1];
								ge2_rst_r <= ifc_ad[0];
								rst_hold_f <= 1;
								rst_hold_cnt <= RST_HOLD_TIME;
							end
				`FLHCSR:	begin
								fbank_override_r <= ifc_ad[6];
								fbank_sel1_r <= ifc_ad[1];
								fbank_sel2_r <= ifc_ad[0];
							end
				`WDCSR:		begin
								wd_en_r <= ifc_ad[7];
								wd_cfg_r <= ifc_ad[2:0];
							end
				`WDKICK:	begin
								if(ifc_ad == 8'h5a)
									wd_kick_r <= ~wd_kick_r;
								else
									wd_kick_r <= wd_kick_r;
							end
				`FANCSR:	begin
								fan_pwm_r <= ifc_ad[3:0];
							end
				`LEDCSR:	begin
								led_r <= ifc_ad[0];
							end
				`MISCCSR:	begin
								po1vdd_en_r <= ifc_ad[7];
								po2vdd_en_r <= ifc_ad[6];
							end
				`BOOTOR:	begin
								boot_override_r <= ifc_ad[0];
							end
				`BOOTCFG1:	begin
								cfg_sys_pll_r[0] <= ifc_ad[7];
								cfg_sys_pll_r[1] <= ifc_ad[6];
								cfg_sys_pll_r[2] <= ifc_ad[5];
								cfg_sys_speed_r <= ifc_ad[4];
								cfg_core_pll_r[0] <= ifc_ad[3];
								cfg_core_pll_r[1] <= ifc_ad[2];
								cfg_core_pll_r[2] <= ifc_ad[1];
								cfg_core_speed_r <= ifc_ad[0];
							end
				`BOOTCFG2:	begin
								cfg_ddr_pll_r[0] <= ifc_ad[7];
								cfg_ddr_pll_r[1] <= ifc_ad[6];
								cfg_ddr_pll_r[2] <= ifc_ad[5];
								cfg_ddr_speed_r[0] <= ifc_ad[4];
								cfg_ddr_speed_r[1] <= ifc_ad[3];
								cfg_plat_speed_r <= ifc_ad[2];
								cfg_boot_seq_r[0] <= ifc_ad[1];
								cfg_boot_seq_r[1] <= ifc_ad[0];
							end
				`BOOTCFG3:	begin
								cfg_cpu_boot_r <= ifc_ad[7];
								cfg_rom_loc_r[0] <= ifc_ad[6];
								cfg_rom_loc_r[1] <= ifc_ad[5];
								cfg_rom_loc_r[2] <= ifc_ad[4];
								cfg_rom_loc_r[3] <= ifc_ad[3];
								cfg_sb_dis_r <= ifc_ad[2];
								cfg_svr_r[0] <= ifc_ad[1];
								cfg_svr_r[1] <= ifc_ad[0];
							end		
				`BOOTCFG4:	begin
								cfg_gpinput_r[0] <= ifc_ad[7];
								cfg_gpinput_r[1] <= ifc_ad[6];
								cfg_gpinput_r[2] <= ifc_ad[5];
								cfg_gpinput_r[3] <= ifc_ad[4];
								cfg_eng_use_r[0] <= ifc_ad[3];
								cfg_eng_use_r[1] <= ifc_ad[2];
							end		
				default:	begin
							end
			endcase
		end
		else if(cpld_cs & cpld_oe)
		begin
			case(ifc_a23_27)
				`CHIPID1:	ifc_dout <= 8'h55;
				`CHIPID2:	ifc_dout <= 8'haa;
				`HWVER:		ifc_dout <= 8'h02;
				`SWVER:		ifc_dout <= 8'h02;
				`RSTCON:	begin
								ifc_dout[7] <= sw_rst_r;
								ifc_dout[6:2] <= 5'b00000;
								ifc_dout[1] <= ge1_rst_r;
								ifc_dout[0] <= ge2_rst_r;
							end
				`FLHCSR:	begin
								ifc_dout[7] <= boot_flash_sel;
								ifc_dout[6] <= fbank_override_r;
								ifc_dout[5:2] <= 4'b0000;
								//ifc_dout[5:4] <= 2'b00;
								//ifc_dout[3] <= fbank_sel1;
								//ifc_dout[2] <= fbank_sel2;
								ifc_dout[1] <= fbank_sel1_r;
								ifc_dout[0] <= fbank_sel2_r;
							end
				`WDCSR:		begin
								ifc_dout[7] <= wd_en_r;
								ifc_dout[6:3] <= 4'b0000;
								ifc_dout[2:0] <= wd_cfg_r;
							end
				`FANCSR:	begin
								ifc_dout[7:4] <= 4'b0000;
								ifc_dout[3:0] <= fan_pwm_r;
							end
				`LEDCSR:	begin
								ifc_dout[7:1] <= 7'b0000000;
								ifc_dout[0] <= led_r;
							end
				`MISCCSR:	begin
								ifc_dout[7] <= po1vdd_en_r;
								ifc_dout[6] <= po2vdd_en_r;
								ifc_dout[5:3] <= 3'b000;
								ifc_dout[2] <= test_sel_n;
								ifc_dout[1] <= ~ext_pwr_det;
								ifc_dout[0] <= ~therm_n;
							end
				`BOOTOR:	begin
								ifc_dout[7:1] <= 7'b0000000;
								ifc_dout[0] <= boot_override_r;
							end
				`BOOTCFG1:	begin
								ifc_dout[7] <= cfg_sys_pll_r[0];
								ifc_dout[6] <= cfg_sys_pll_r[1];
								ifc_dout[5] <= cfg_sys_pll_r[2];
								ifc_dout[4] <= cfg_sys_speed_r;
								ifc_dout[3] <= cfg_core_pll_r[0];
								ifc_dout[2] <= cfg_core_pll_r[1];
								ifc_dout[1] <= cfg_core_pll_r[2];
								ifc_dout[0] <= cfg_core_speed_r;
							end
				`BOOTCFG2:	begin
								ifc_dout[7] <= cfg_ddr_pll_r[0];
								ifc_dout[6] <= cfg_ddr_pll_r[1];
								ifc_dout[5] <= cfg_ddr_pll_r[2];
								ifc_dout[4] <= cfg_ddr_speed_r[0];
								ifc_dout[3] <= cfg_ddr_speed_r[1];
								ifc_dout[2] <= cfg_plat_speed_r;
								ifc_dout[1] <= cfg_boot_seq_r[0];
								ifc_dout[0] <= cfg_boot_seq_r[1];
							end
				`BOOTCFG3:	begin
								ifc_dout[7] <= cfg_cpu_boot_r;
								ifc_dout[6] <= cfg_rom_loc_r[0];
								ifc_dout[5] <= cfg_rom_loc_r[1];
								ifc_dout[4] <= cfg_rom_loc_r[2];
								ifc_dout[3] <= cfg_rom_loc_r[3];
								ifc_dout[2] <= cfg_sb_dis_r;
								ifc_dout[1] <= cfg_svr_r[0];
								ifc_dout[0] <= cfg_svr_r[1];
							end		
				`BOOTCFG4:	begin
								ifc_dout[7] <= cfg_gpinput_r[0];
								ifc_dout[6] <= cfg_gpinput_r[1];
								ifc_dout[5] <= cfg_gpinput_r[2];
								ifc_dout[4] <= cfg_gpinput_r[3];
								ifc_dout[3] <= cfg_eng_use_r[0];
								ifc_dout[2] <= cfg_eng_use_r[1];  
								ifc_dout[1:0] <= 2'b00;
							end
				default:	ifc_dout <= 8'h00;
			endcase
		end
		else
			ifc_dout <= 8'hzz;
		if(rst_hold_f)
		begin
			if(rst_hold_cnt==32'h00000000)
			begin
				rst_hold_f <= 0;
				sw_rst_r <= 0;
				ge1_rst_r <= 0;
				ge2_rst_r <= 0;
			end
			else
				rst_hold_cnt <= rst_hold_cnt - 1;
		end
	end
end

always @(posedge cpld_refclk)
begin
	if(!ps_rst_n)
		pwm_cnt <= 4'b0000;
	else
		pwm_cnt <= pwm_cnt + 1;
end

always @(posedge cpld_refclk)
begin
	if(pwm_cnt < fan_pwm_r)
		fan_out <= 1;
	else
		fan_out <= 0;
end

always @(posedge cpld_refclk)
begin
	if(led_clk_cnt>=16'd16384)
	begin
		led_clk_cnt <= 16'h0000;
		led_flash_out <= ~led_flash_out;
	end
	else
		led_clk_cnt <= led_clk_cnt + 1;
end

always @(posedge cpld_refclk)
begin
	if(!ps_rst_n)
	begin
		hrst_req_r <= 1;
		hrst_req_old[1:0] <= 2'b00;
	end
	else
	begin
		hrst_req_old[1] <= hrst_req_old[0];
		hrst_req_old[0] <= hrst_req_n;
		if(hrst_req_old[1:0] == 2'b10)
			hrst_req_r <= 0;
		else
			hrst_req_r <= 1;
	end
end

always @(posedge cpld_refclk)
begin
	if(!hrst_req_r)
		global_rst_r <= 0;
	else
	begin
		if(!global_rst_n)
		begin
			global_rst_r <= 1;
			global_rst_cnt <= 0;
		end
		else
		begin
			if(!global_rst_r)
			begin
				if(global_rst_cnt >= 6'd30)
				begin
					global_rst_cnt <= 0;
					global_rst_r <= 1;
				end
				else
					global_rst_cnt <= global_rst_cnt + 1;
			end
		end
	end
end	
	
always @(posedge cpld_refclk)
begin
	if(!ps_rst_n)
	begin
		sw_rst_rr <= 0;
		sw_rst_old[1:0] <= 2'b00;
		sw_rst_cnt <= 0;
	end
	else
	begin
		sw_rst_old[1] <= sw_rst_old[0];
		sw_rst_old[0] <= sw_rst_r;
		if(sw_rst_old[1:0] == 2'b01)
			sw_rst_rr <= 1;
		if(sw_rst_rr)
		begin
			if(sw_rst_cnt >= 8'd30)
			begin
				sw_rst_rr <= 0;
				sw_rst_cnt <= 0;
			end
			else
				sw_rst_cnt <= sw_rst_cnt + 1;
		end
	end
end

always @(posedge cpld_refclk)
begin
	if(!ps_rst_n)
	begin
		pex_rst_r <= 1;
		pex_rst_old[2:0] <= 3'b000;
	end
	else
	begin
		pex_rst_old[2] <= pex_rst_old[1];
		pex_rst_old[1] <= pex_rst_old[0];
		pex_rst_old[0] <= pex_rst_n;
		if(pex_rst_old[2:0] == 3'b000)
			pex_rst_r <= 1;
		else
			pex_rst_r <= 0;
	end
end

always @(posedge cpld_refclk)
begin
	if(!bootcfg_rst_n)
	begin
		sw_cfg_sb_dis_r <= hrst_req_n;
	end
end

always @(posedge cpld_refclk)
begin
	if(!bootcfg_rst_n)
	begin
		povdd_delay_cnt <= 2'b00;
		povdd_out <= 0;
	end
	else
	begin
		povdd_delay_cnt <= povdd_delay_cnt + 1;
		if(povdd_delay_cnt == 2'b10)
			povdd_out <= 1;
	end
end

assign	nor_cs_n = (~boot_flash_sel)? ifc_cs0_n : ifc_cs1_n;
assign	nand_cs_n = (~boot_flash_sel)? ifc_cs1_n : ifc_cs0_n;

assign	ifc_rb0_n = (~boot_flash_sel)? 1'b1 : nand_rb_n;
assign	ifc_rb1_n = (~boot_flash_sel)? nand_rb_n : 1'b1;
assign	cpu_trst_n = global_rst_n & cop_trst_n;
assign	hrst_n = bootcfg_rst_n;
assign	nor_rst_n = global_rst_n;
assign	ddr3_rst_n = (global_rst_n & cop_hrst_n)? 1'bz : 1'b0;
assign	ge1_rst_n =  bootcfg_rst_n & ~ge1_rst_r;
assign	ge2_rst_n =  bootcfg_rst_n & ~ge2_rst_r;

assign	fbank_sel1 = fbank_override_r? fbank_sel1_r : 1'bz;
assign	fbank_sel2 = fbank_override_r? fbank_sel2_r : 1'bz;

assign	wdi = wd_kick_r;
assign	wd_cfg = wd_cfg_r;

assign	fan_pwm = fan_out;

assign	cpld_int_n = 1'b1;
assign	po1vdd_en = sw_cfg_sb_dis_r? po1vdd_en_r : povdd_out;
assign	po2vdd_en = sw_cfg_sb_dis_r? po2vdd_en_r : povdd_out;
assign	load_pwr_n = bootcfg_rst_n;
assign	ps_1v0_mgn = (~vcore_mgn)? 1'b0 : 1'bz;
assign	led_grn = led_r? led_flash_out : 1'b0;

assign	ifc_ad[0] = bootcfg_rst_n? (cpld_oe? ifc_dout[0] : 1'bz) : (boot_override_r? cfg_sys_pll_r[0] : 1'bz);
assign	ifc_ad[1] = bootcfg_rst_n? (cpld_oe? ifc_dout[1] : 1'bz) : (boot_override_r? cfg_sys_pll_r[1] : 1'bz);
assign	ifc_ad[2] = bootcfg_rst_n? (cpld_oe? ifc_dout[2] : 1'bz) : (boot_override_r? cfg_sys_pll_r[2] : 1'bz);
assign	ready = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_sys_speed_r : 1'bz);
assign	ifc_ad[3] = bootcfg_rst_n? (cpld_oe? ifc_dout[3] : 1'bz) : (boot_override_r? cfg_core_pll_r[0] : 1'bz);
assign	ifc_ad[4] = bootcfg_rst_n? (cpld_oe? ifc_dout[4] : 1'bz) : (boot_override_r? cfg_core_pll_r[1] : 1'bz);
assign	ifc_ad[5] = bootcfg_rst_n? (cpld_oe? ifc_dout[5] : 1'bz) : (boot_override_r? cfg_core_pll_r[2] : 1'bz);
assign	ifc_ad[6] = bootcfg_rst_n? (cpld_oe? ifc_dout[6] : 1'bz) : (boot_override_r? cfg_core_speed_r : 1'bz);
assign	sw_tsec1_txd0 = boot_override_r? cfg_ddr_pll_r[0] : 1'bz;
assign	sw_tsec1_txd1 = boot_override_r? cfg_ddr_pll_r[1] : 1'bz;
assign	uart1_rts_n = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_ddr_pll_r[2] : 1'bz);
assign	ieee1588_clk_out = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_ddr_speed_r[0] : 1'bz);
assign	ieee1588_pulse_out = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_ddr_speed_r[1] : 1'bz);
assign	ifc_par1 = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_plat_speed_r : 1'bz);
assign	ifc_a23_27[1] = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_boot_seq_r[0] : 1'bz);
assign	ifc_a19 = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_boot_seq_r[1] : 1'bz);
assign	dma_ddone0_n = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_cpu_boot_r : 1'bz);
assign	ifc_ad[7] = bootcfg_rst_n? (cpld_oe? ifc_dout[7] : 1'bz) : (boot_override_r? cfg_rom_loc_r[0] : sw_cfg_rom_loc[0]);
assign	ifc_ad8 = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_rom_loc_r[1] : sw_cfg_rom_loc[1]);
assign	ifc_a23_27[3] = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_rom_loc_r[2] : sw_cfg_rom_loc[2]);
assign	dma_dack0_n = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_rom_loc_r[3] : sw_cfg_rom_loc[3]);
assign	hrst_req_n = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_sb_dis_r : 1'bz);
assign	sw_tsec2_txd0 = boot_override_r? cfg_svr_r[0] : 1'bz;
assign	ckstp_out_n = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_svr_r[1] : 1'bz);
assign	ifc_avd = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_gpinput_r[0] : 1'bz);
assign	ifc_we_n = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_gpinput_r[1] : 1'bz);
assign	ifc_cle = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_gpinput_r[2] : 1'bz);
assign	uart0_txd = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_gpinput_r[3] : 1'bz);
assign	sw_ec_mdc = boot_override_r? cfg_eng_use_r[0] : 1'bz;
assign	uart0_rts_n = bootcfg_rst_n? 1'bz : (boot_override_r? cfg_eng_use_r[1] : 1'bz);

assign	ifc_a23_27[4] = 1'bz;
assign	ifc_a23_27[2] = 1'bz;
assign	ifc_a23_27[0] = 1'bz;

endmodule
